/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.ByteProcessor;
import java.awt.Color;

public class BinaryProcessor
extends ByteProcessor {
    private ByteProcessor parent;
    static final int OUTLINE = 0;

    public BinaryProcessor(ByteProcessor ip) {
        super(ip.getWidth(), ip.getHeight(), (byte[])ip.getPixels(), ip.getColorModel());
        this.setRoi(ip.getRoi());
        this.parent = ip;
    }

    void process(int type, int count) {
        int inc = this.roiHeight / 25;
        if (inc < 1) {
            inc = 1;
        }
        int bgColor = 255;
        if (this.parent.isInvertedLut()) {
            bgColor = 0;
        }
        byte[] pixels2 = (byte[])this.parent.getPixelsCopy();
        int v = 0;
        int rowOffset = this.width;
        for (int y = this.yMin; y <= this.yMax; ++y) {
            int offset = this.xMin + y * this.width;
            int p2 = pixels2[offset - rowOffset - 1] & 0xFF;
            int p3 = pixels2[offset - rowOffset] & 0xFF;
            int p5 = pixels2[offset - 1] & 0xFF;
            int p6 = pixels2[offset] & 0xFF;
            int p8 = pixels2[offset + rowOffset - 1] & 0xFF;
            int p9 = pixels2[offset + rowOffset] & 0xFF;
            for (int x = this.xMin; x <= this.xMax; ++x) {
                int p1 = p2;
                p2 = p3;
                p3 = pixels2[offset - rowOffset + 1] & 0xFF;
                int p4 = p5;
                p5 = p6;
                p6 = pixels2[offset + 1] & 0xFF;
                int p7 = p8;
                p8 = p9;
                p9 = pixels2[offset + rowOffset + 1] & 0xFF;
                switch (type) {
                    case 0: {
                        v = p5;
                        if (v == bgColor || p1 == bgColor || p2 == bgColor || p3 == bgColor || p4 == bgColor || p6 == bgColor || p7 == bgColor || p8 == bgColor || p9 == bgColor) break;
                        v = bgColor;
                    }
                }
                this.pixels[offset++] = (byte)v;
            }
            if (y % inc != 0) continue;
            this.parent.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
        }
        this.parent.hideProgress();
    }

    public void skeletonize() {
        int pixelsRemoved;
        int[] table = new int[]{0, 0, 0, 1, 0, 0, 1, 3, 0, 0, 3, 1, 1, 0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 3, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 3, 0, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 2, 0, 0, 0, 3, 1, 0, 0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 1, 3, 0, 0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 1, 0, 0, 0, 0, 2, 2, 0, 0, 2, 0, 0, 0};
        int pass = 0;
        do {
            this.setColor(Color.white);
            if (this.roiX == 0) {
                this.moveTo(0, 0);
                this.lineTo(0, this.height - 1);
            }
            if (this.roiY == 0) {
                this.moveTo(0, 0);
                this.lineTo(this.width - 1, 0);
            }
            if (this.roiWidth == this.width) {
                this.moveTo(this.width - 1, 0);
                this.lineTo(this.width - 1, this.height - 1);
            }
            if (this.roiHeight == this.height) {
                this.moveTo(0, this.height - 1);
                this.lineTo(this.width, this.height - 1);
            }
            this.snapshot();
            pixelsRemoved = this.thin(pass++, table);
            this.snapshot();
        } while ((pixelsRemoved = this.thin(pass++, table)) > 0);
    }

    int thin(int pass, int[] table) {
        int inc = this.roiHeight / 25;
        if (inc < 1) {
            inc = 1;
        }
        int bgColor = 255;
        if (this.parent.isInvertedLut()) {
            bgColor = 0;
        }
        byte[] pixels2 = (byte[])this.getPixelsCopy();
        int rowOffset = this.width;
        int pixelsRemoved = 0;
        int count = 100;
        for (int y = this.yMin; y <= this.yMax; ++y) {
            int offset = this.xMin + y * this.width;
            for (int x = this.xMin; x <= this.xMax; ++x) {
                int p5 = pixels2[offset] & 0xFF;
                int v = p5;
                if (v != bgColor) {
                    int p1 = pixels2[offset - rowOffset - 1] & 0xFF;
                    int p2 = pixels2[offset - rowOffset] & 0xFF;
                    int p3 = pixels2[offset - rowOffset + 1] & 0xFF;
                    int p4 = pixels2[offset - 1] & 0xFF;
                    int p6 = pixels2[offset + 1] & 0xFF;
                    int p7 = pixels2[offset + rowOffset - 1] & 0xFF;
                    int p8 = pixels2[offset + rowOffset] & 0xFF;
                    int p9 = pixels2[offset + rowOffset + 1] & 0xFF;
                    int index = 0;
                    if (p1 != bgColor) {
                        index |= 1;
                    }
                    if (p2 != bgColor) {
                        index |= 2;
                    }
                    if (p3 != bgColor) {
                        index |= 4;
                    }
                    if (p6 != bgColor) {
                        index |= 8;
                    }
                    if (p9 != bgColor) {
                        index |= 0x10;
                    }
                    if (p8 != bgColor) {
                        index |= 0x20;
                    }
                    if (p7 != bgColor) {
                        index |= 0x40;
                    }
                    if (p4 != bgColor) {
                        index |= 0x80;
                    }
                    int code = table[index];
                    if ((pass & 1) == 1) {
                        if (code == 2 || code == 3) {
                            v = bgColor;
                            ++pixelsRemoved;
                        }
                    } else if (code == 1 || code == 3) {
                        v = bgColor;
                        ++pixelsRemoved;
                    }
                }
                this.pixels[offset++] = (byte)v;
            }
            if (y % inc != 0) continue;
            this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
        }
        this.hideProgress();
        return pixelsRemoved;
    }

    public void outline() {
        this.process(0, 0);
    }
}

