/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.plugin.PlugIn;
import java.awt.Dimension;
import java.awt.Frame;

public class WindowOrganizer
implements PlugIn {
    private static final int XSTART = 4;
    private static final int YSTART = 80;
    private static final int XOFFSET = 8;
    private static final int YOFFSET = 24;
    private static final int MAXSTEP = 200;
    private static final int GAP = 2;
    private int titlebarHeight = IJ.isMacintosh() ? 40 : 20;

    public void run(String arg) {
        int[] wList = WindowManager.getIDList();
        if (arg.equals("show")) {
            this.showAll(wList);
            return;
        }
        if (wList == null) {
            IJ.noImage();
            return;
        }
        if (arg.equals("tile")) {
            this.tileWindows(wList);
        } else {
            this.cascadeWindows(wList);
        }
    }

    void tileWindows(int[] wList) {
        int vloc;
        int hloc;
        boolean theyFit;
        int vspace;
        Dimension screen = IJ.getScreenSize();
        int minWidth = Integer.MAX_VALUE;
        int minHeight = Integer.MAX_VALUE;
        boolean allSameSize = true;
        int width = 0;
        int height = 0;
        double totalWidth = 0.0;
        double totalHeight = 0.0;
        for (int i = 0; i < wList.length; ++i) {
            ImageWindow win = this.getWindow(wList[i]);
            if (win == null) continue;
            Dimension d = win.getSize();
            int w = d.width;
            int h = d.height + this.titlebarHeight;
            if (i == 0) {
                width = w;
                height = h;
            }
            if (w != width || h != height) {
                allSameSize = false;
            }
            if (w < minWidth) {
                minWidth = w;
            }
            if (h < minHeight) {
                minHeight = h;
            }
            totalWidth += (double)w;
            totalHeight += (double)h;
        }
        int nPics = wList.length;
        double averageWidth = totalWidth / (double)nPics;
        double averageHeight = totalHeight / (double)nPics;
        int tileWidth = (int)averageWidth;
        int tileHeight = (int)averageHeight;
        int hspace = screen.width - 4;
        if (tileWidth > hspace) {
            tileWidth = hspace;
        }
        if (tileHeight > (vspace = screen.height - 80)) {
            tileHeight = vspace;
        }
        do {
            hloc = 4;
            vloc = 80;
            theyFit = true;
            int i = 0;
            do {
                ++i;
                if (hloc + tileWidth > screen.width) {
                    hloc = 4;
                    if ((vloc += tileHeight) + tileHeight > screen.height) {
                        theyFit = false;
                    }
                }
                hloc = hloc + tileWidth + 2;
            } while (theyFit && i < nPics);
            if (theyFit) continue;
            tileWidth = (int)((double)tileWidth * 0.98 + 0.5);
            tileHeight = (int)((double)tileHeight * 0.98 + 0.5);
        } while (!theyFit);
        int nColumns = (screen.width - 4) / (tileWidth + 2);
        int nRows = nPics / nColumns;
        if (nPics % nColumns != 0) {
            ++nRows;
        }
        hloc = 4;
        vloc = 80;
        for (int i = 0; i < nPics; ++i) {
            ImageWindow win;
            if (hloc + tileWidth > screen.width) {
                hloc = 4;
                vloc += tileHeight;
            }
            if ((win = this.getWindow(wList[i])) != null) {
                win.setLocation(hloc, vloc);
                ImageCanvas canvas = win.getCanvas();
                while ((double)win.getSize().width * 0.85 >= (double)tileWidth && canvas.getMagnification() > 0.03125) {
                    canvas.zoomOut(0, 0);
                }
                win.toFront();
            }
            hloc += tileWidth + 2;
        }
    }

    ImageWindow getWindow(int id) {
        ImageWindow win = null;
        ImagePlus imp = WindowManager.getImage(id);
        if (imp != null) {
            win = imp.getWindow();
        }
        return win;
    }

    void cascadeWindows(int[] wList) {
        Dimension screen = IJ.getScreenSize();
        int x = 4;
        int y = 80;
        int xstep = 0;
        int xstart = 4;
        for (int i = 0; i < wList.length; ++i) {
            ImageWindow win = this.getWindow(wList[i]);
            if (win == null) continue;
            Dimension d = win.getSize();
            if (i == 0 && (xstep = (int)((double)d.width * 0.8)) > 200) {
                xstep = 200;
            }
            if ((double)y + (double)d.height * 0.67 > (double)screen.height) {
                if ((double)(xstart += xstep) + (double)d.width * 0.67 > (double)screen.width) {
                    xstart = 12;
                }
                x = xstart;
                y = 80;
            }
            win.setLocation(x, y);
            win.toFront();
            x += 8;
            y += 24;
        }
    }

    void showAll(int[] wList) {
        Frame[] frames;
        if (wList != null) {
            for (int i = 0; i < wList.length; ++i) {
                ImageWindow win = this.getWindow(wList[i]);
                if (win == null) continue;
                win.toFront();
            }
        }
        if ((frames = WindowManager.getNonImageWindows()) != null) {
            for (int i = 0; i < frames.length; ++i) {
                frames[i].toFront();
            }
        }
        IJ.getInstance().toFront();
    }
}

