/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.gui.Roi;
import ij.gui.YesNoCancelDialog;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.awt.Frame;
import java.awt.Rectangle;

public class RGBStackConverter
implements PlugIn {
    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        CompositeImage cimg = imp.isComposite() ? (CompositeImage)imp : null;
        int size = imp.getStackSize();
        if ((size < 2 || size > 3) && cimg == null) {
            IJ.error("A 2 or 3 image stack, or a HyperStack, required");
            return;
        }
        int type = imp.getType();
        if (cimg == null && type != 0 && type != 1) {
            IJ.error("8-bit or 16-bit grayscale stack required");
            return;
        }
        if (!imp.lock()) {
            return;
        }
        Undo.reset();
        String title = imp.getTitle() + " (RGB)";
        if (cimg != null) {
            this.compositeToRGB(cimg, title);
        } else if (type == 1) {
            this.sixteenBitsToRGB(imp);
        } else {
            ImagePlus imp2 = imp.createImagePlus();
            imp2.setStack(title, imp.getStack());
            ImageConverter ic = new ImageConverter(imp2);
            ic.convertRGBStackToRGB();
            imp2.show();
        }
        imp.unlock();
    }

    void compositeToRGB(CompositeImage imp, String title) {
        int frames;
        int slices;
        int images;
        int channels = imp.getNChannels();
        if (channels == (images = channels * (slices = imp.getNSlices()) * (frames = imp.getNFrames()))) {
            this.compositeImageToRGB(imp, title);
            return;
        }
        String msg = null;
        msg = frames > 1 ? "Convert all " + frames + " frames?" : "Convert all " + slices + " slices?";
        if (!IJ.isMacro()) {
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)IJ.getInstance(), "Convert to RGB", msg);
            if (d.cancelPressed()) {
                return;
            }
            if (!d.yesPressed()) {
                this.compositeImageToRGB(imp, title);
                return;
            }
        }
        if (!imp.isHyperStack()) {
            return;
        }
        int n = frames;
        if (n == 1) {
            n = slices;
        }
        ImageStack stack = new ImageStack(imp.getWidth(), imp.getHeight());
        int c = imp.getChannel();
        int z = imp.getSlice();
        int t = imp.getFrame();
        for (int i = 1; i <= n; ++i) {
            if (frames == 1) {
                imp.setPositionWithoutUpdate(imp.getChannel(), i, imp.getFrame());
            } else {
                imp.setPositionWithoutUpdate(imp.getChannel(), imp.getSlice(), i);
            }
            stack.addSlice(null, new ColorProcessor(imp.getImage()));
        }
        imp.setPosition(c, z, t);
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack(title, stack);
        Object info = imp.getProperty("Info");
        if (info != null) {
            imp2.setProperty("Info", info);
        }
        imp2.show();
    }

    void compositeImageToRGB(CompositeImage imp, String title) {
        if (imp.getMode() == 1) {
            ImagePlus imp2 = imp.createImagePlus();
            imp.updateImage();
            imp2.setProcessor(title, new ColorProcessor(imp.getImage()));
            imp2.show();
            return;
        }
        ImageStack stack = new ImageStack(imp.getWidth(), imp.getHeight());
        int c = imp.getChannel();
        int n = imp.getNChannels();
        for (int i = 1; i <= n; ++i) {
            imp.setPositionWithoutUpdate(i, 1, 1);
            stack.addSlice(null, new ColorProcessor(imp.getImage()));
        }
        imp.setPosition(c, 1, 1);
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack(title, stack);
        Object info = imp.getProperty("Info");
        if (info != null) {
            imp2.setProperty("Info", info);
        }
        imp2.show();
    }

    void sixteenBitsToRGB(ImagePlus imp) {
        Rectangle r;
        Roi roi = imp.getRoi();
        if (roi != null) {
            r = roi.getBounds();
            int width = r.width;
            int height = r.height;
        } else {
            r = new Rectangle(0, 0, imp.getWidth(), imp.getHeight());
        }
        ImageStack stack1 = imp.getStack();
        ImageStack stack2 = new ImageStack(r.width, r.height);
        for (int i = 1; i <= stack1.getSize(); ++i) {
            ImageProcessor ip = stack1.getProcessor(i);
            ip.setRoi(r);
            ImageProcessor ip2 = ip.crop();
            ip2 = ip2.convertToByte(true);
            stack2.addSlice(null, ip2);
        }
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack(imp.getTitle() + " (RGB)", stack2);
        ImageConverter ic = new ImageConverter(imp2);
        ic.convertRGBStackToRGB();
        imp2.show();
    }
}

