/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Line;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.gui.YesNoCancelDialog;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.MeasurementsWriter;
import ij.plugin.Straightener;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.FloatStatistics;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.text.TextPanel;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Properties;

public class Analyzer
implements PlugInFilter,
Measurements {
    private String arg;
    private ImagePlus imp;
    private ResultsTable rt;
    private int measurements;
    private StringBuffer min;
    private StringBuffer max;
    private StringBuffer mean;
    private StringBuffer sd;
    private static final int[] list = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 512, 2048, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 256, 1024, 4096, 0x200000};
    private static final String MEASUREMENTS = "measurements";
    private static final String MARK_WIDTH = "mark.width";
    private static final String PRECISION = "precision";
    private static boolean unsavedMeasurements;
    public static Color darkBlue;
    private static int systemMeasurements;
    public static int markWidth;
    public static int precision;
    private static float[] umeans;
    private static ResultsTable systemRT;
    private static int redirectTarget;
    private static String redirectTitle;
    static int firstParticle;
    static int lastParticle;
    private static boolean summarized;
    private static boolean switchingModes;
    private static boolean showMin;

    public Analyzer() {
        this.rt = systemRT;
        this.rt.setPrecision((systemMeasurements & 0x200000) != 0 ? -precision : precision);
        this.measurements = systemMeasurements;
    }

    public Analyzer(ImagePlus imp) {
        this();
        this.imp = imp;
    }

    public Analyzer(ImagePlus imp, int measurements, ResultsTable rt) {
        this.imp = imp;
        this.measurements = measurements;
        this.rt = rt;
    }

    public int setup(String arg, ImagePlus imp) {
        this.arg = arg;
        this.imp = imp;
        IJ.register(Analyzer.class);
        if (arg.equals("set")) {
            this.doSetDialog();
            return 4096;
        }
        if (arg.equals("sum")) {
            this.summarize();
            return 4096;
        }
        if (arg.equals("clear")) {
            if (IJ.macroRunning()) {
                unsavedMeasurements = false;
            }
            Analyzer.resetCounter();
            return 4096;
        }
        return 159;
    }

    public void run(ImageProcessor ip) {
        this.measure();
        this.displayResults();
    }

    void doSetDialog() {
        String[] titles;
        String NONE = "None";
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            titles = new String[]{NONE};
        } else {
            titles = new String[wList.length + 1];
            titles[0] = NONE;
            for (int i = 0; i < wList.length; ++i) {
                ImagePlus imp = WindowManager.getImage(wList[i]);
                titles[i + 1] = imp != null ? imp.getTitle() : "";
            }
        }
        ImagePlus tImp = WindowManager.getImage(redirectTarget);
        String target = tImp != null ? tImp.getTitle() : NONE;
        String macroOptions = Macro.getOptions();
        if (macroOptions != null && macroOptions.indexOf("circularity ") != -1) {
            Macro.setOptions(macroOptions.replaceAll("circularity ", "shape "));
        }
        GenericDialog gd = new GenericDialog("Set Measurements", IJ.getInstance());
        String[] labels = new String[18];
        boolean[] states = new boolean[18];
        labels[0] = "Area";
        states[0] = (systemMeasurements & 1) != 0;
        labels[1] = "Mean Gray Value";
        states[1] = (systemMeasurements & 2) != 0;
        labels[2] = "Standard Deviation";
        states[2] = (systemMeasurements & 4) != 0;
        labels[3] = "Modal Gray Value";
        states[3] = (systemMeasurements & 8) != 0;
        labels[4] = "Min & Max Gray Value";
        states[4] = (systemMeasurements & 0x10) != 0;
        labels[5] = "Centroid";
        states[5] = (systemMeasurements & 0x20) != 0;
        labels[6] = "Center of Mass";
        states[6] = (systemMeasurements & 0x40) != 0;
        labels[7] = "Perimeter";
        states[7] = (systemMeasurements & 0x80) != 0;
        labels[8] = "Bounding Rectangle";
        states[8] = (systemMeasurements & 0x200) != 0;
        labels[9] = "Fit Ellipse";
        states[9] = (systemMeasurements & 0x800) != 0;
        labels[10] = "Shape Descriptors";
        states[10] = (systemMeasurements & 0x2000) != 0;
        labels[11] = "Feret's Diameter";
        states[11] = (systemMeasurements & 0x4000) != 0;
        labels[12] = "Integrated Density";
        states[12] = (systemMeasurements & 0x8000) != 0;
        labels[13] = "Median";
        states[13] = (systemMeasurements & 0x10000) != 0;
        labels[14] = "Skewness";
        states[14] = (systemMeasurements & 0x20000) != 0;
        labels[15] = "Kurtosis";
        states[15] = (systemMeasurements & 0x40000) != 0;
        labels[16] = "Area_Fraction";
        states[16] = (systemMeasurements & 0x80000) != 0;
        labels[17] = "Slice Number";
        states[17] = (systemMeasurements & 0x100000) != 0;
        gd.setInsets(0, 0, 0);
        gd.addCheckboxGroup(10, 2, labels, states);
        labels = new String[4];
        states = new boolean[4];
        labels[0] = "Limit to Threshold";
        states[0] = (systemMeasurements & 0x100) != 0;
        labels[1] = "Display Label";
        states[1] = (systemMeasurements & 0x400) != 0;
        labels[2] = "Invert Y Coordinates";
        states[2] = (systemMeasurements & 0x1000) != 0;
        labels[3] = "Scientific Notation";
        states[3] = (systemMeasurements & 0x200000) != 0;
        gd.setInsets(0, 0, 0);
        gd.addCheckboxGroup(2, 2, labels, states);
        gd.setInsets(15, 0, 0);
        gd.addChoice("Redirect To:", titles, target);
        gd.setInsets(5, 0, 0);
        gd.addNumericField("Decimal Places (0-9):", precision, 0, 2, "");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.setOptions(gd);
        int index = gd.getNextChoiceIndex();
        redirectTarget = index == 0 ? 0 : wList[index - 1];
        redirectTitle = titles[index];
        int prec = (int)gd.getNextNumber();
        if (prec < 0) {
            prec = 0;
        }
        if (prec > 9) {
            prec = 9;
        }
        if (prec != precision) {
            precision = prec;
            this.rt.setPrecision((systemMeasurements & 0x200000) != 0 ? -precision : precision);
            if (IJ.isResultsWindow()) {
                IJ.setColumnHeadings("");
                this.updateHeadings();
            }
        }
    }

    void setOptions(GenericDialog gd) {
        int oldMeasurements = systemMeasurements;
        int previous = 0;
        boolean b = false;
        for (int i = 0; i < list.length; ++i) {
            b = gd.getNextBoolean();
            previous = list[i];
            if (b) {
                systemMeasurements |= list[i];
                continue;
            }
            systemMeasurements &= ~list[i];
        }
        if ((oldMeasurements & 0xFFFFFEFF) != (systemMeasurements & 0xFFFFFEFF) && IJ.isResultsWindow()) {
            this.rt.setPrecision((systemMeasurements & 0x200000) != 0 ? -precision : precision);
            this.rt.update(systemMeasurements, this.imp != null ? this.imp.getRoi() : null);
        }
        if ((systemMeasurements & 0x400) == 0) {
            systemRT.disableRowLabels();
        }
    }

    public void measure() {
        ImageStatistics stats;
        String sliceHdr = this.rt.getColumnHeading(25);
        if (!(sliceHdr != null && sliceHdr.charAt(0) == 'S' || this.reset())) {
            return;
        }
        lastParticle = 0;
        firstParticle = 0;
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.getType() == 10) {
            this.measurePoint(roi);
            return;
        }
        if (roi != null && roi.isLine()) {
            this.measureLength(roi);
            return;
        }
        if (roi != null && roi.getType() == 8) {
            this.measureAngle(roi);
            return;
        }
        if (Analyzer.isRedirectImage()) {
            stats = this.getRedirectStats(this.measurements, roi);
            if (stats == null) {
                return;
            }
        } else {
            stats = this.imp.getStatistics(this.measurements);
        }
        if (!IJ.isResultsWindow() && IJ.getInstance() != null) {
            this.reset();
        }
        this.saveResults(stats, roi);
    }

    boolean reset() {
        boolean ok = true;
        if (this.rt.getCounter() > 0) {
            ok = Analyzer.resetCounter();
        }
        if (ok && this.rt.getColumnHeading(30) == null) {
            this.rt.setDefaultHeadings();
        }
        return ok;
    }

    public static boolean isRedirectImage() {
        return redirectTarget != 0;
    }

    public static ImagePlus getRedirectImage(ImagePlus currentImage) {
        ImagePlus rImp = WindowManager.getImage(redirectTarget);
        if (rImp == null) {
            IJ.error("Analyzer", "Redirect image (\"" + redirectTitle + "\")\n" + "not found.");
            redirectTarget = 0;
            Macro.abort();
            return null;
        }
        if (rImp.getWidth() != currentImage.getWidth() || rImp.getHeight() != currentImage.getHeight()) {
            IJ.error("Analyzer", "Redirect image (\"" + redirectTitle + "\") \n" + "is not the same size as the current image.");
            Macro.abort();
            return null;
        }
        return rImp;
    }

    ImageStatistics getRedirectStats(int measurements, Roi roi) {
        ImagePlus redirectImp = Analyzer.getRedirectImage(this.imp);
        if (redirectImp == null) {
            return null;
        }
        int depth = redirectImp.getStackSize();
        if (depth > 1 && depth == this.imp.getStackSize()) {
            redirectImp.setSlice(this.imp.getCurrentSlice());
        }
        ImageProcessor ip = redirectImp.getProcessor();
        if (this.imp.getTitle().equals("mask") && this.imp.getBitDepth() == 8) {
            ip.setMask(this.imp.getProcessor());
            ip.setRoi(0, 0, this.imp.getWidth(), this.imp.getHeight());
        } else {
            ip.setRoi(roi);
        }
        return ImageStatistics.getStatistics(ip, measurements, redirectImp.getCalibration());
    }

    void measurePoint(Roi roi) {
        if (this.rt.getCounter() > 0) {
            if (!IJ.isResultsWindow()) {
                this.reset();
            }
            boolean update = false;
            int index = this.rt.getColumnIndex("X");
            if (index < 0 || !this.rt.columnExists(index)) {
                update = true;
            }
            if ((index = this.rt.getColumnIndex("Slice")) < 0 || !this.rt.columnExists(index)) {
                update = true;
            }
            if (update) {
                this.rt.update(this.measurements, roi);
            }
        }
        Polygon p = roi.getPolygon();
        for (int i = 0; i < p.npoints; ++i) {
            ImageProcessor ip = this.imp.getProcessor();
            ip.setRoi(p.xpoints[i], p.ypoints[i], 1, 1);
            ImageStatistics stats = ImageStatistics.getStatistics(ip, this.measurements, this.imp.getCalibration());
            this.saveResults(stats, new PointRoi(p.xpoints[i], p.ypoints[i]));
            if (i == p.npoints - 1) continue;
            this.displayResults();
        }
    }

    void measureAngle(Roi roi) {
        if (this.rt.getCounter() > 0) {
            int index;
            if (!IJ.isResultsWindow()) {
                this.reset();
            }
            if ((index = this.rt.getColumnIndex("Angle")) < 0 || !this.rt.columnExists(index)) {
                this.rt.update(this.measurements, roi);
            }
        }
        ImageProcessor ip = this.imp.getProcessor();
        ip.setRoi(roi.getPolygon());
        ImageStatistics stats = ImageStatistics.getStatistics(ip, this.measurements, this.imp.getCalibration());
        this.saveResults(stats, roi);
    }

    void measureLength(Roi roi) {
        ImageProcessor ip2;
        if (this.rt.getCounter() > 0) {
            if (!IJ.isResultsWindow()) {
                this.reset();
            }
            boolean update = false;
            int index = this.rt.getColumnIndex("Length");
            if (index < 0 || !this.rt.columnExists(index)) {
                update = true;
            }
            if (!(roi.getType() != 5 || (index = this.rt.getColumnIndex("Angle")) >= 0 && this.rt.columnExists(index))) {
                update = true;
            }
            if (update) {
                this.rt.update(this.measurements, roi);
            }
        }
        boolean straightLine = roi.getType() == 5;
        int lineWidth = Line.getWidth();
        Rectangle saveR = null;
        if (straightLine && lineWidth > 1) {
            ip2 = this.imp.getProcessor();
            saveR = ip2.getRoi();
            ip2.setRoi(roi.getPolygon());
        } else if (lineWidth > 1) {
            ip2 = new Straightener().straightenLine(this.imp, lineWidth);
        } else {
            ProfilePlot profile = new ProfilePlot(this.imp);
            double[] values = profile.getProfile();
            if (values == null) {
                return;
            }
            ip2 = new FloatProcessor(values.length, 1, values);
            if (straightLine) {
                Line l = (Line)roi;
                if ((l.y1 == l.y2 || l.x1 == l.x2) && (double)l.x1 == l.x1d && (double)l.y1 == l.y1d && (double)l.x2 == l.x2d && (double)l.y2 == l.y2d) {
                    ip2.setRoi(0, 0, ip2.getWidth() - 1, 1);
                }
            }
        }
        ImageStatistics stats = ImageStatistics.getStatistics(ip2, 31, null);
        if (saveR != null) {
            ip2.setRoi(saveR);
        }
        this.saveResults(stats, roi);
    }

    public void saveResults(ImageStatistics stats, Roi roi) {
        if (this.rt.getColumnHeading(30) == null) {
            this.reset();
        }
        this.incrementCounter();
        int counter = this.rt.getCounter();
        if (counter <= 20) {
            if (umeans == null) {
                umeans = new float[20];
            }
            Analyzer.umeans[counter - 1] = (float)stats.umean;
        }
        if ((this.measurements & 0x400) != 0) {
            this.rt.addLabel("Label", this.getFileName());
        }
        if ((this.measurements & 1) != 0) {
            this.rt.addValue(0, stats.area);
        }
        if ((this.measurements & 2) != 0) {
            this.rt.addValue(1, stats.mean);
        }
        if ((this.measurements & 4) != 0) {
            this.rt.addValue(2, stats.stdDev);
        }
        if ((this.measurements & 8) != 0) {
            this.rt.addValue(3, stats.dmode);
        }
        if ((this.measurements & 0x10) != 0) {
            if (showMin) {
                this.rt.addValue(4, stats.min);
            }
            this.rt.addValue(5, stats.max);
        }
        if ((this.measurements & 0x20) != 0) {
            this.rt.addValue(6, stats.xCentroid);
            this.rt.addValue(7, stats.yCentroid);
        }
        if ((this.measurements & 0x40) != 0) {
            this.rt.addValue(8, stats.xCenterOfMass);
            this.rt.addValue(9, stats.yCenterOfMass);
        }
        if ((this.measurements & 0x80) != 0 || (this.measurements & 0x2000) != 0) {
            double perimeter = roi != null ? roi.getLength() : 0.0;
            if ((this.measurements & 0x80) != 0) {
                this.rt.addValue(10, perimeter);
            }
            if ((this.measurements & 0x2000) != 0) {
                boolean isArea;
                double circularity;
                double d = circularity = perimeter == 0.0 ? 0.0 : Math.PI * 4 * (stats.area / (perimeter * perimeter));
                if (circularity > 1.0) {
                    circularity = 1.0;
                }
                this.rt.addValue(18, circularity);
                Polygon ch = null;
                boolean bl = isArea = roi != null && roi.isArea();
                if (isArea && roi.getType() != 9) {
                    ch = roi.getConvexHull();
                }
                this.rt.addValue(28, isArea ? stats.major / stats.minor : 0.0);
                this.rt.addValue(29, isArea ? 4.0 * stats.area / (Math.PI * stats.major * stats.major) : 0.0);
                this.rt.addValue(30, ch != null ? (double)stats.pixelCount / this.getArea(ch) : 0.0);
            }
        }
        if ((this.measurements & 0x200) != 0) {
            if (roi != null && roi.isLine()) {
                Rectangle bounds = roi.getBounds();
                this.rt.addValue(11, (double)bounds.x);
                this.rt.addValue(12, (double)bounds.y);
                this.rt.addValue(13, (double)bounds.width);
                this.rt.addValue(14, (double)bounds.height);
            } else {
                this.rt.addValue(11, stats.roiX);
                this.rt.addValue(12, stats.roiY);
                this.rt.addValue(13, stats.roiWidth);
                this.rt.addValue(14, stats.roiHeight);
            }
        }
        if ((this.measurements & 0x800) != 0) {
            this.rt.addValue(15, stats.major);
            this.rt.addValue(16, stats.minor);
            this.rt.addValue(17, stats.angle);
        }
        if ((this.measurements & 0x4000) != 0) {
            double[] a;
            boolean extras = true;
            double FeretDiameter = 0.0;
            double feretAngle = 0.0;
            double minFeret = 0.0;
            if (roi != null && (a = roi.getFeretValues()) != null) {
                FeretDiameter = a[0];
                feretAngle = a[1];
                minFeret = a[2];
            }
            this.rt.addValue(19, FeretDiameter);
            this.rt.addValue(26, feretAngle);
            this.rt.addValue(27, minFeret);
        }
        if ((this.measurements & 0x8000) != 0) {
            this.rt.addValue(20, stats.area * stats.mean);
        }
        if ((this.measurements & 0x10000) != 0) {
            this.rt.addValue(21, stats.median);
        }
        if ((this.measurements & 0x20000) != 0) {
            this.rt.addValue(22, stats.skewness);
        }
        if ((this.measurements & 0x40000) != 0) {
            this.rt.addValue(23, stats.kurtosis);
        }
        if ((this.measurements & 0x80000) != 0) {
            this.rt.addValue(24, stats.areaFraction);
        }
        if ((this.measurements & 0x100000) != 0) {
            this.rt.addValue(25, this.imp != null ? (double)this.imp.getCurrentSlice() : 1.0);
        }
        if (roi != null) {
            if (roi.isLine()) {
                this.rt.addValue("Length", roi.getLength());
                if (roi.getType() == 5) {
                    double angle = 0.0;
                    Line l = (Line)roi;
                    angle = roi.getAngle(l.x1, l.y1, l.x2, l.y2);
                    this.rt.addValue("Angle", angle);
                }
            } else if (roi.getType() == 8) {
                this.rt.addValue("Angle", ((PolygonRoi)roi).getAngle());
            } else if (roi.getType() == 10) {
                this.savePoints(roi);
            }
        }
    }

    final double getArea(Polygon p) {
        int carea = 0;
        for (int i = 0; i < p.npoints; ++i) {
            int iminus1 = i - 1;
            if (iminus1 < 0) {
                iminus1 = p.npoints - 1;
            }
            carea += (p.xpoints[i] + p.xpoints[iminus1]) * (p.ypoints[i] - p.ypoints[iminus1]);
        }
        return Math.abs((double)carea / 2.0);
    }

    void savePoints(Roi roi) {
        if (this.imp == null) {
            this.rt.addValue("X", 0.0);
            this.rt.addValue("Y", 0.0);
            this.rt.addValue("Slice", 0.0);
            return;
        }
        if ((this.measurements & 1) != 0) {
            this.rt.addValue(0, 0.0);
        }
        Polygon p = roi.getPolygon();
        ImageProcessor ip = this.imp.getProcessor();
        Calibration cal = this.imp.getCalibration();
        int x = p.xpoints[0];
        int y = p.ypoints[0];
        double value = ip.getPixelValue(x, y);
        if (markWidth > 0) {
            ip.setColor(Toolbar.getForegroundColor());
            ip.setLineWidth(markWidth);
            ip.moveTo(x, y);
            ip.lineTo(x, y);
            this.imp.updateAndDraw();
            ip.setLineWidth(Line.getWidth());
        }
        this.rt.addValue("X", cal.getX(x));
        this.rt.addValue("Y", cal.getY(y, this.imp.getHeight()));
        this.rt.addValue("Slice", cal.getZ(this.imp.getCurrentSlice()));
        if (this.imp.getProperty("FHT") != null) {
            double center = (double)this.imp.getWidth() / 2.0;
            double r = Math.sqrt(((double)x - center) * ((double)x - center) + ((double)(y = this.imp.getHeight() - y - 1) - center) * ((double)y - center));
            if (r < 1.0) {
                r = 1.0;
            }
            double theta = Math.atan2((double)y - center, (double)x - center);
            if ((theta = theta * 180.0 / Math.PI) < 0.0) {
                theta = 360.0 + theta;
            }
            this.rt.addValue("R", (double)this.imp.getWidth() / r * cal.pixelWidth);
            this.rt.addValue("Theta", theta);
        }
        if ((this.measurements & 2) == 0) {
            this.rt.addValue("Mean", value);
        }
    }

    String getFileName() {
        String s = "";
        if (this.imp != null) {
            String roiName;
            if (redirectTarget != 0) {
                ImagePlus rImp = WindowManager.getImage(redirectTarget);
                if (rImp != null) {
                    s = rImp.getTitle();
                }
            } else {
                s = this.imp.getTitle();
            }
            Roi roi = this.imp.getRoi();
            String string = roiName = roi != null ? roi.getName() : null;
            if (roiName != null) {
                s = s + ":" + roiName;
            }
            if (this.imp.getStackSize() > 1) {
                ImageStack stack = this.imp.getStack();
                int currentSlice = this.imp.getCurrentSlice();
                String label = stack.getShortSliceLabel(currentSlice);
                String colon = s.equals("") ? "" : ":";
                s = label != null && !label.equals("") ? s + colon + label : s + colon + currentSlice;
            }
        }
        return s;
    }

    public void displayResults() {
        int counter = this.rt.getCounter();
        if (counter == 1) {
            IJ.setColumnHeadings(this.rt.getColumnHeadings());
        }
        IJ.write(this.rt.getRowAsString(counter - 1));
    }

    public void updateHeadings() {
        String tableHeadings;
        TextPanel tp = IJ.getTextPanel();
        if (tp == null) {
            return;
        }
        String worksheetHeadings = tp.getColumnHeadings();
        if (worksheetHeadings.equals(tableHeadings = this.rt.getColumnHeadings())) {
            return;
        }
        IJ.setColumnHeadings(tableHeadings);
        int n = this.rt.getCounter();
        if (n > 0) {
            StringBuffer sb = new StringBuffer(n * tableHeadings.length());
            for (int i = 0; i < n; ++i) {
                sb.append(this.rt.getRowAsString(i) + "\n");
            }
            tp.append(new String(sb));
        }
    }

    public String n(double n) {
        String s = (double)Math.round(n) == n ? IJ.d2s(n, 0) : IJ.d2s(n, precision);
        return s + "\t";
    }

    void incrementCounter() {
        if (this.rt == null) {
            this.rt = systemRT;
        }
        this.rt.incrementCounter();
        unsavedMeasurements = true;
    }

    public void summarize() {
        String worksheetHeadings;
        TextPanel tp;
        this.rt = systemRT;
        if (this.rt.getCounter() == 0) {
            return;
        }
        if (summarized) {
            this.rt.show("Results");
        }
        this.measurements = systemMeasurements;
        this.min = new StringBuffer(100);
        this.max = new StringBuffer(100);
        this.mean = new StringBuffer(100);
        this.sd = new StringBuffer(100);
        this.min.append("Min\t");
        this.max.append("Max\t");
        this.mean.append("Mean\t");
        this.sd.append("SD\t");
        if ((this.measurements & 0x400) != 0) {
            this.min.append("\t");
            this.max.append("\t");
            this.mean.append("\t");
            this.sd.append("\t");
        }
        this.summarizeAreas();
        int index = this.rt.getColumnIndex("Angle");
        if (this.rt.columnExists(index)) {
            this.add2(index);
        }
        if (this.rt.columnExists(index = this.rt.getColumnIndex("Length"))) {
            this.add2(index);
        }
        if ((tp = IJ.getTextPanel()) != null && (worksheetHeadings = tp.getColumnHeadings()).equals("")) {
            IJ.setColumnHeadings(this.rt.getColumnHeadings());
        }
        IJ.write("");
        IJ.write(new String(this.mean));
        IJ.write(new String(this.sd));
        IJ.write(new String(this.min));
        IJ.write(new String(this.max));
        IJ.write("");
        this.mean = null;
        this.sd = null;
        this.min = null;
        this.max = null;
        summarized = true;
    }

    void summarizeAreas() {
        if ((this.measurements & 1) != 0) {
            this.add2(0);
        }
        if ((this.measurements & 2) != 0) {
            this.add2(1);
        }
        if ((this.measurements & 4) != 0) {
            this.add2(2);
        }
        if ((this.measurements & 8) != 0) {
            this.add2(3);
        }
        if ((this.measurements & 0x10) != 0) {
            if (showMin) {
                this.add2(4);
            }
            this.add2(5);
        }
        if ((this.measurements & 0x20) != 0) {
            this.add2(6);
            this.add2(7);
        }
        if ((this.measurements & 0x40) != 0) {
            this.add2(8);
            this.add2(9);
        }
        if ((this.measurements & 0x80) != 0) {
            this.add2(10);
        }
        if ((this.measurements & 0x200) != 0) {
            this.add2(11);
            this.add2(12);
            this.add2(13);
            this.add2(14);
        }
        if ((this.measurements & 0x800) != 0) {
            this.add2(15);
            this.add2(16);
            this.add2(17);
        }
        if ((this.measurements & 0x2000) != 0) {
            this.add2(18);
        }
        if ((this.measurements & 0x4000) != 0) {
            this.add2(19);
        }
        if ((this.measurements & 0x8000) != 0) {
            this.add2(20);
        }
        if ((this.measurements & 0x10000) != 0) {
            this.add2(21);
        }
        if ((this.measurements & 0x20000) != 0) {
            this.add2(22);
        }
        if ((this.measurements & 0x40000) != 0) {
            this.add2(23);
        }
        if ((this.measurements & 0x80000) != 0) {
            this.add2(24);
        }
        if ((this.measurements & 0x100000) != 0) {
            this.add2(25);
        }
        if ((this.measurements & 0x4000) != 0) {
            this.add2(26);
            this.add2(27);
        }
        if ((this.measurements & 0x2000) != 0) {
            this.add2(28);
            this.add2(29);
            this.add2(30);
        }
    }

    private void add2(int column) {
        float[] c;
        float[] fArray = c = column >= 0 ? this.rt.getColumn(column) : null;
        if (c != null) {
            FloatProcessor ip = new FloatProcessor(c.length, 1, c, null);
            if (ip == null) {
                return;
            }
            FloatStatistics stats = new FloatStatistics(ip);
            if (stats == null) {
                return;
            }
            this.mean.append(this.n(stats.mean));
            this.min.append(this.n(stats.min));
            this.max.append(this.n(stats.max));
            this.sd.append(this.n(stats.stdDev));
        } else {
            this.mean.append("-\t");
            this.min.append("-\t");
            this.max.append("-\t");
            this.sd.append("-\t");
        }
    }

    public static int getCounter() {
        return systemRT.getCounter();
    }

    public static synchronized boolean resetCounter() {
        TextPanel tp = IJ.isResultsWindow() ? IJ.getTextPanel() : null;
        int counter = systemRT.getCounter();
        int lineCount = tp != null ? IJ.getTextPanel().getLineCount() : 0;
        ImageJ ij = IJ.getInstance();
        boolean macro = IJ.macroRunning() && !switchingModes || Interpreter.isBatchMode();
        switchingModes = false;
        if (counter > 0 && lineCount > 0 && unsavedMeasurements && !macro && ij != null && !ij.quitting()) {
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)ij, "ImageJ", "Save " + counter + " measurements?");
            if (d.cancelPressed()) {
                return false;
            }
            if (d.yesPressed() && !new MeasurementsWriter().save("")) {
                return false;
            }
        }
        umeans = null;
        systemRT.reset();
        unsavedMeasurements = false;
        if (tp != null) {
            tp.clear();
        }
        summarized = false;
        return true;
    }

    public static void setUnsavedMeasurements(boolean b) {
        unsavedMeasurements = b;
    }

    public static int getMeasurements() {
        return systemMeasurements;
    }

    public static void setMeasurements(int measurements) {
        systemMeasurements = measurements;
    }

    public static void setMeasurement(int option, boolean state) {
        systemMeasurements = state ? (systemMeasurements |= option) : (systemMeasurements &= ~option);
    }

    public static void savePreferences(Properties prefs) {
        prefs.put(MEASUREMENTS, Integer.toString(systemMeasurements));
        prefs.put(MARK_WIDTH, Integer.toString(markWidth));
        prefs.put(PRECISION, Integer.toString(precision));
    }

    public static float[] getUMeans() {
        return umeans;
    }

    public static ResultsTable getResultsTable() {
        return systemRT;
    }

    public static int getPrecision() {
        return precision;
    }

    public static void setPrecision(int decimalPlaces) {
        if (decimalPlaces < 0) {
            decimalPlaces = 0;
        }
        if (decimalPlaces > 9) {
            decimalPlaces = 9;
        }
        precision = decimalPlaces;
    }

    public static int updateY(int y, int imageHeight) {
        if ((systemMeasurements & 0x1000) != 0) {
            y = imageHeight - y - 1;
        }
        return y;
    }

    public static double updateY(double y, int imageHeight) {
        if ((systemMeasurements & 0x1000) != 0) {
            y = (double)imageHeight - y - 1.0;
        }
        return y;
    }

    public static void setDefaultHeadings() {
        systemRT.setDefaultHeadings();
    }

    public static void setOption(String option, boolean b) {
        if (option.indexOf("min") != -1) {
            showMin = b;
        }
    }

    static {
        darkBlue = new Color(0, 0, 160);
        systemMeasurements = Prefs.getInt(MEASUREMENTS, 19);
        markWidth = Prefs.getInt(MARK_WIDTH, 0);
        precision = Prefs.getInt(PRECISION, 3);
        umeans = new float[20];
        systemRT = new ResultsTable();
        redirectTitle = "";
        showMin = true;
    }
}

